$fn=90; //sets the resolution to render circular forms
in2mm = 25.4; //inches to mm

//to ensure that the box and lid are compatible, the sizes for both are specified below and the variable below determines which one is rendered. The user should set the variable to 1, then render the box and save the stl file. Then render the lid and save the stl for it with a different name.
printphase = 1; //1 = box, 2=lid, 3=both (don't print this way)

wall_thickness = 0.125*in2mm; //thickness of the wall of the box
inside_width = 1.5*in2mm; //width of the inside of the box, actual width is reduced by the supports
inside_length = 3*in2mm; //length of the inside of the box. Actual length is reduced by the supports
inside_depth = 0.75*in2mm; //depth of the inside of the box

top_plate_thickness = 0.0625*in2mm; //this is the thickness of the box lid

support_diameter = 0.20*in2mm; //this is the outside diameter of the cylindrical supports for the lid
//I have had good luck printing holes to be tapped for machine screws. After the print it done, manually ream out the hole with the tap drill to make sure that the hole is the right size and is round, then carefully tap it.
support_hole = 0.089*in2mm; //0.089 for 4-40 #35=0.11 for 6-32 tap., #29=0.136 for 8-32
support_hole_depth = 0.5*in2mm; //depth of the hole in the support. Make sure that this is deep enough to allow the threads to be cut deep enough for the screws to be used
lid_hole = 0.125*in2mm + 0.35; //holes in the lid

height = inside_depth + wall_thickness; //top plate ends up at this height
support_height = height-top_plate_thickness; //top of cylindrical supports

extra = 0.2*in2mm; //extra to make sure of a clean cut

slack = 0.5; //gap to ensure that the lid fits into the top of the box. 3D printers often print slightly larger than the specified dimension as a result of the nozzle diameter.


top_plate_width = inside_width + wall_thickness; //width of top plate
top_plate_length = inside_length + wall_thickness; //length of the top plate

length = top_plate_length+wall_thickness; //outside length of box
width = top_plate_width+wall_thickness; //width of box

//the next three lines specify the location of the hole in the left side of the box. You can duplicate the code below to add the desired number of holes at your desired locations.
hole1x = -length/2; //x coordinate of hole in the left side
hole1y = 0*in2mm; //y coordinate of hole in the left side
hole1z = 0.3*in2mm + wall_thickness; //z coordinate of hole in the left side
hole1diameter = 0.3*in2mm; //diameter of the hole in the left side, set to zero to not make the hole

//location of the hole in the right side of the box
hole2x = length/2; //x coordinate of the hole in the right side of the box
hole2y = 0*in2mm; //y coordinate of the hole in the right side of the box
hole2z = 0.3*in2mm + wall_thickness; //z coordinate of the hole in the right side of the box
hole2diameter = 0.3*in2mm; //diameter of the hole in the right side of the box. Set to zero to not make a hole

//The two lines below allow for manual positioning of the supports. Uncomment these two lines and comment out the other two for manual support positioning
//supportdx = 0.5*2.31*in2mm; //manual offset of support in x
//supportdy = 0.5*1.13*in2mm; //manual offset of support in y
//The two lines below allow for automatic placement of the supports in the corners of the box
supportdx = (length/2-wall_thickness-support_diameter/2+0.3); //the offset of the support location from the middle of the box in the x direction. The extra 0.3 results in the supports being slightly embedded in the walls for extra strength.
supportdy = (width/2-wall_thickness-support_diameter/2+0.3); //the offset of the support location from the middle of the box in the y direction.

echo("width=",width/in2mm,"length = ",length/in2mm); //prints out the outside side of the box


if(printphase == 1 || printphase == 3){  //execute the code to make the box if printphase is 1 or 3
  difference(){ //this difference expression is associated with the holes in the posts
    union(){ //this union is associated with adding the posts
      difference(){ //this difference expression is associated with making the holes in the sides of the box
        difference(){ //this difference expression is associated with removing the top plate thickness to create the shoulder
          //these lines of code make the basic box
          difference(){
            translate(-[length/2,width/2,0]) {
              cube([length,width,height]);
            } //box outer shape with center of base at 0,0
            translate(-[length/2-wall_thickness,width/2-wall_thickness,-wall_thickness]) {
              cube([length-2*wall_thickness,width-2*wall_thickness,height+extra]);
            } //carve out box interior 
          } //end of difference to carve out box interior
      
          //remove top plate thickness to create shoulder
          translate(-[top_plate_length/2, top_plate_width/2,-(height-top_plate_thickness)]) {
            cube([top_plate_length ,top_plate_width,top_plate_thickness+extra]);
          }
        } //end of difference to remove top plate
    
        //hole1: hole in left side of box
        translate([hole1x, hole1y, hole1z]) {
          rotate([0,90,0]){
            cylinder(d=hole1diameter, h=(wall_thickness + 2*extra),center=true);
          }
        }
        //hole2: hole in right side of box
        translate([hole2x, hole2y, hole2z]) {
          rotate([0,90,0]){
            cylinder(d=hole2diameter, h=(wall_thickness + 2*extra),center=true);
          }
        }
      } //end of difference to remove holes in the sides
      
      //below are four posts to secure the top
      translate([supportdx, supportdy, 0]) { //cylinder starts out at (0,0) and needs to be moved to the desired location
        cylinder(d=support_diameter, h=support_height,center=false);  //support post of support_diameter and support_height located at +dx +dy
      }
      translate([-supportdx, supportdy, 0]) {
        cylinder(d=support_diameter, h=support_height,center=false); //support post at -dx +dy
      }
      translate([supportdx, -supportdy, 0]) {
        cylinder(d=support_diameter, h=support_height,center=false); //support post at dx -dy
      }
      translate([-supportdx, -supportdy, 0]) {
        cylinder(d=support_diameter, h=support_height,center=false); //support post at -dx -dy
      }
    } //end of union above which added the posts
    
    //below are holes in posts which can go through the bottom of box if the support_hole_depth is too big.
    translate([supportdx, supportdy, height-top_plate_thickness-support_hole_depth]){ //shift cylinder up to remove material at the top of the post
      cylinder(d=support_hole, h=support_hole_depth+extra, center=false); //this cylinder is removed to become the hole
    }
    translate([-supportdx, supportdy, height-top_plate_thickness-support_hole_depth]){
      cylinder(d=support_hole, h=support_hole_depth+extra, center=false);
    }
    translate([supportdx, -supportdy, height-top_plate_thickness-support_hole_depth]){
      cylinder(d=support_hole, h=support_hole_depth+extra, center=false);
    }
    translate([-supportdx, -supportdy, height-top_plate_thickness-support_hole_depth]){
      cylinder(d=support_hole, h=support_hole_depth+extra, center=false);
    }
  } //end of difference which created the holes in the posts
} //this is the end of the if (printphase == 1 || printphase == 3)
if(printphase == 2 || printphase == 3){   //execute the code to make the lid if printphase is 2 or 3
  difference(){ //this difference makes the holes in the box lid
    //the next line makes the lid
    translate(-[top_plate_length/2-slack/2, top_plate_width/2-slack/2,-(height-top_plate_thickness)]) {
      cube([top_plate_length-slack ,top_plate_width-slack,top_plate_thickness]);
    } //top plate which is slightly smaller than the area which was previously used to form the shoulder
    //below are the four holes in the lid
    translate([supportdx, supportdy, (height-top_plate_thickness)/2]) {
      translate([0, 0, height-top_plate_thickness-support_hole_depth]){
        cylinder(d=lid_hole, h=support_hole_depth+extra, center=true);
      }
    }
    translate([-supportdx, supportdy, (height-top_plate_thickness)/2]) {
      translate([0, 0, height-top_plate_thickness-support_hole_depth]){
        cylinder(d=lid_hole, h=support_hole_depth+extra, center=true);
      }  
    }
    translate([supportdx, -supportdy, (height-top_plate_thickness)/2]) {
      translate([0, 0, height-top_plate_thickness-support_hole_depth]){
        cylinder(d=lid_hole, h=support_hole_depth+extra, center=true);
      }
    }
    translate([-supportdx, -supportdy, (height-top_plate_thickness)/2]) {
      translate([0, 0, height-top_plate_thickness-support_hole_depth]){
        cylinder(d=lid_hole, h=support_hole_depth+extra, center=true);
      }
    }
  } //this is the end of the difference to make the holes in the lid
} //this is the end of if(printphase == 2 || printphase == 3)

